/*
 * Decompiled with CFR 0.152.
 */
package scala.scalajs.niocharset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import scala.Array$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.scalajs.niocharset.UTF_16_Common$;

@ScalaSignature(bytes="\u0006\u0001\u00055cAB\u0001\u0003\u0003\u0003\u0011\u0001BA\u0007V)\u001a{\u0016GN0D_6lwN\u001c\u0006\u0003\u0007\u0011\t!B\\5pG\"\f'o]3u\u0015\t)a!A\u0004tG\u0006d\u0017M[:\u000b\u0003\u001d\tQa]2bY\u0006\u001c\"\u0001A\u0005\u0011\u0005)\tR\"A\u0006\u000b\u00051i\u0011aB2iCJ\u001cX\r\u001e\u0006\u0003\u001d=\t1A\\5p\u0015\u0005\u0001\u0012\u0001\u00026bm\u0006L!AE\u0006\u0003\u000f\rC\u0017M]:fi\"AA\u0003\u0001B\u0001B\u0003%a#\u0001\u0003oC6,7\u0001\u0001\t\u0003/yq!\u0001\u0007\u000f\u0011\u0005e1Q\"\u0001\u000e\u000b\u0005m)\u0012A\u0002\u001fs_>$h(\u0003\u0002\u001e\r\u00051\u0001K]3eK\u001aL!a\b\u0011\u0003\rM#(/\u001b8h\u0015\tib\u0001\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\u001d\tG.[1tKN\u00042\u0001J\u0013\u0017\u001b\u00051\u0011B\u0001\u0014\u0007\u0005\u0015\t%O]1z\u0011!A\u0003A!b\u0001\n\u0013I\u0013AC3oI&\fgN\\3tgV\t!\u0006\u0005\u0002%W%\u0011AF\u0002\u0002\u0004\u0013:$\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u0017\u0015tG-[1o]\u0016\u001c8\u000f\t\u0005\u0006a\u0001!\t\"M\u0001\u0007y%t\u0017\u000e\u001e \u0015\tI\"TG\u000e\t\u0003g\u0001i\u0011A\u0001\u0005\u0006)=\u0002\rA\u0006\u0005\u0006E=\u0002\ra\t\u0005\u0006Q=\u0002\rA\u000b\u0005\u0006q\u0001!\t!O\u0001\tG>tG/Y5ogR\u0011!(\u0010\t\u0003ImJ!\u0001\u0010\u0004\u0003\u000f\t{w\u000e\\3b]\")ah\u000ea\u0001\u0013\u0005!A\u000f[1u\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003)qWm\u001e#fG>$WM\u001d\u000b\u0002\u0005B\u0011!bQ\u0005\u0003\t.\u0011ab\u00115beN,G\u000fR3d_\u0012,'\u000fC\u0003G\u0001\u0011\u0005q)\u0001\u0006oK^,enY8eKJ$\u0012\u0001\u0013\t\u0003\u0015%K!AS\u0006\u0003\u001d\rC\u0017M]:fi\u0016s7m\u001c3fe\u001a!A\n\u0001\u0003N\u0005\u001d!UmY8eKJ\u001c\"a\u0013\"\t\u000bAZE\u0011A(\u0015\u0003A\u0003\"!U&\u000e\u0003\u0001AAbU&\u0005\u0002\u0003\u0015\t\u00111A\u0005\n%\n!h]2bY\u0006$3oY1mC*\u001cHE\\5pG\"\f'o]3uIU#fiX\u00197?\u000e{W.\\8oI\u0011+7m\u001c3fe\u0012\"SM\u001c3jC:tWm]:\t\u0019U[E\u0011!A\u0003\u0002\u0003\u0007I\u0011\u0002,\u0002}M\u001c\u0017\r\\1%g\u000e\fG.\u00196tI9Lwn\u00195beN,G\u000fJ+U\r~\u000bdgX\"p[6|g\u000e\n#fG>$WM\u001d\u0013%K:$\u0017.\u00198oKN\u001cx\fJ3r)\t9&\f\u0005\u0002%1&\u0011\u0011L\u0002\u0002\u0005+:LG\u000fC\u0004\\)\u0006\u0005\t\u0019\u0001\u0016\u0002\u0007a$\u0013\u0007C\u0005^\u0017\n\u0005\t\u0011)Q\u0005U\u0005Y4oY1mC\u0012\u001a8-\u00197bUN$c.[8dQ\u0006\u00148/\u001a;%+R3u,\r\u001c`\u0007>lWn\u001c8%\t\u0016\u001cw\u000eZ3sI\u0011*g\u000eZ5b]:,7o\u001d\u0011\t\u000b}[E\u0011\u000b1\u0002\u0013%l\u0007\u000f\u001c*fg\u0016$H#A,\t\u000b\t\\E\u0011A2\u0002\u0015\u0011,7m\u001c3f\u0019>|\u0007\u000fF\u0002eO6\u0004\"AC3\n\u0005\u0019\\!aC\"pI\u0016\u0014(+Z:vYRDQ\u0001[1A\u0002%\f!!\u001b8\u0011\u0005)\\W\"A\u0007\n\u00051l!A\u0003\"zi\u0016\u0014UO\u001a4fe\")a.\u0019a\u0001_\u0006\u0019q.\u001e;\u0011\u0005)\u0004\u0018BA9\u000e\u0005)\u0019\u0005.\u0019:Ck\u001a4WM\u001d\u0004\u0005g\u0002!AOA\u0004F]\u000e|G-\u001a:\u0014\u0005ID\u0005\"\u0002\u0019s\t\u00031H#A<\u0011\u0005E\u0013\bbB=s\u0001\u0004%IA_\u0001\u000f]\u0016,G\rV8Xe&$XMQ(N+\u0005Q\u0004b\u0002?s\u0001\u0004%I!`\u0001\u0013]\u0016,G\rV8Xe&$XMQ(N?\u0012*\u0017\u000f\u0006\u0002X}\"91l_A\u0001\u0002\u0004Q\u0004bBA\u0001e\u0002\u0006KAO\u0001\u0010]\u0016,G\rV8Xe&$XMQ(NA!)qL\u001dC)A\"9\u0011q\u0001:\u0005\u0002\u0005%\u0011AC3oG>$W\rT8paR)A-a\u0003\u0002\u000e!1\u0001.!\u0002A\u0002=DaA\\A\u0003\u0001\u0004Iw\u0001CA\t\u0005!\u0005!!a\u0005\u0002\u001bU#fiX\u00197?\u000e{W.\\8o!\r\u0019\u0014Q\u0003\u0004\b\u0003\tA\tAAA\f'\u0011\t)\"!\u0007\u0011\u0007\u0011\nY\"C\u0002\u0002\u001e\u0019\u0011a!\u00118z%\u00164\u0007b\u0002\u0019\u0002\u0016\u0011\u0005\u0011\u0011\u0005\u000b\u0003\u0003'A!\"!\n\u0002\u0016\t\u0007IQAA\u0014\u0003)\tU\u000f^8F]\u0012L\u0017M\\\u000b\u0003\u0003Sy!!a\u000b\u001e\u0003\u0001A\u0011\"a\f\u0002\u0016\u0001\u0006i!!\u000b\u0002\u0017\u0005+Ho\\#oI&\fg\u000e\t\u0005\u000b\u0003g\t)B1A\u0005\u0006\u0005U\u0012!\u0003\"jO\u0016sG-[1o+\t\t9d\u0004\u0002\u0002:u\t\u0011\u0001C\u0005\u0002>\u0005U\u0001\u0015!\u0004\u00028\u0005Q!)[4F]\u0012L\u0017M\u001c\u0011\t\u0015\u0005\u0005\u0013Q\u0003b\u0001\n\u000b\t\u0019%\u0001\u0007MSR$H.Z#oI&\fg.\u0006\u0002\u0002F=\u0011\u0011qI\u000f\u0002\u0005!I\u00111JA\u000bA\u00035\u0011QI\u0001\u000e\u0019&$H\u000f\\3F]\u0012L\u0017M\u001c\u0011")
public abstract class UTF_16_Common
extends Charset {
    private final int scala$scalajs$niocharset$UTF_16_Common$$endianness;

    public static int LittleEndian() {
        return UTF_16_Common$.MODULE$.LittleEndian();
    }

    public static int BigEndian() {
        return UTF_16_Common$.MODULE$.BigEndian();
    }

    public static int AutoEndian() {
        return UTF_16_Common$.MODULE$.AutoEndian();
    }

    public int scala$scalajs$niocharset$UTF_16_Common$$endianness() {
        return this.scala$scalajs$niocharset$UTF_16_Common$$endianness;
    }

    @Override
    public boolean contains(Charset that) {
        return true;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder();
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder();
    }

    public UTF_16_Common(String name, String[] aliases, int endianness) {
        this.scala$scalajs$niocharset$UTF_16_Common$$endianness = endianness;
        super(name, aliases);
    }

    public class Decoder
    extends CharsetDecoder {
        private int scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness;

        public int scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness() {
            return this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness;
        }

        public void scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(int x$1) {
            this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness = x$1;
        }

        @Override
        public void implReset() {
            super.implReset();
            this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$$outer().scala$scalajs$niocharset$UTF_16_Common$$endianness());
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            return this.loop$1(in, out);
        }

        public /* synthetic */ UTF_16_Common scala$scalajs$niocharset$UTF_16_Common$Decoder$$$outer() {
            return UTF_16_Common.this;
        }

        private static final char bytes2char$1(int hi, int lo, boolean bigEndian$1) {
            return (char)(bigEndian$1 ? hi << 8 | lo : lo << 8 | hi);
        }

        private final CoderResult loop$1(ByteBuffer in$1, CharBuffer out$1) {
            CoderResult coderResult;
            while (true) {
                int b4;
                boolean wasBOM;
                boolean bl;
                if (in$1.remaining() < 2) {
                    coderResult = CoderResult.UNDERFLOW;
                    break;
                }
                int b1 = in$1.get() & 0xFF;
                int b2 = in$1.get() & 0xFF;
                if (this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness() == 0) {
                    if (b1 == 254 && b2 == 255) {
                        this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(1);
                        bl = true;
                    } else if (b1 == 255 && b2 == 254) {
                        this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(2);
                        bl = true;
                    } else {
                        this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness_$eq(1);
                        bl = false;
                    }
                } else {
                    bl = false;
                }
                if (wasBOM = bl) continue;
                boolean bigEndian = this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness() == 1;
                char c1 = Decoder.bytes2char$1(b1, b2, bigEndian);
                if (Character.isLowSurrogate(c1)) {
                    in$1.position(in$1.position() - 2);
                    coderResult = CoderResult.malformedForLength(2);
                    break;
                }
                if (!Character.isHighSurrogate(c1)) {
                    if (out$1.remaining() == 0) {
                        in$1.position(in$1.position() - 2);
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    out$1.put(c1);
                    continue;
                }
                if (in$1.remaining() < 2) {
                    in$1.position(in$1.position() - 2);
                    coderResult = CoderResult.UNDERFLOW;
                    break;
                }
                int b3 = in$1.get() & 0xFF;
                char c2 = Decoder.bytes2char$1(b3, b4 = in$1.get() & 0xFF, bigEndian);
                if (!Character.isLowSurrogate(c2)) {
                    in$1.position(in$1.position() - 4);
                    coderResult = CoderResult.malformedForLength(4);
                    break;
                }
                if (out$1.remaining() < 2) {
                    in$1.position(in$1.position() - 4);
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                out$1.put(c1);
                out$1.put(c2);
            }
            return coderResult;
        }

        public Decoder() {
            if (UTF_16_Common.this == null) {
                throw null;
            }
            super(UTF_16_Common.this, 0.5f, 1.0f);
            this.scala$scalajs$niocharset$UTF_16_Common$Decoder$$endianness = UTF_16_Common.this.scala$scalajs$niocharset$UTF_16_Common$$endianness();
        }
    }

    public class Encoder
    extends CharsetEncoder {
        private boolean needToWriteBOM;

        private boolean needToWriteBOM() {
            return this.needToWriteBOM;
        }

        private void needToWriteBOM_$eq(boolean x$1) {
            this.needToWriteBOM = x$1;
        }

        @Override
        public void implReset() {
            super.implReset();
            this.needToWriteBOM_$eq(this.scala$scalajs$niocharset$UTF_16_Common$Encoder$$$outer().scala$scalajs$niocharset$UTF_16_Common$$endianness() == 0);
        }

        @Override
        public CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            if (this.needToWriteBOM()) {
                if (out.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                out.put((byte)254);
                out.put((byte)255);
                this.needToWriteBOM_$eq(false);
            }
            boolean bigEndian = this.scala$scalajs$niocharset$UTF_16_Common$Encoder$$$outer().scala$scalajs$niocharset$UTF_16_Common$$endianness() != 2;
            return this.loop$2(in, out, bigEndian);
        }

        public /* synthetic */ UTF_16_Common scala$scalajs$niocharset$UTF_16_Common$Encoder$$$outer() {
            return UTF_16_Common.this;
        }

        private static final void putChar$1(char c, ByteBuffer out$2, boolean bigEndian$2) {
            if (bigEndian$2) {
                out$2.put((byte)(c >> 8));
                out$2.put((byte)c);
            } else {
                out$2.put((byte)c);
                out$2.put((byte)(c >> 8));
            }
        }

        private final CoderResult loop$2(CharBuffer in$2, ByteBuffer out$2, boolean bigEndian$2) {
            CoderResult coderResult;
            while (true) {
                if (in$2.remaining() == 0) {
                    coderResult = CoderResult.UNDERFLOW;
                    break;
                }
                char c1 = in$2.get();
                if (Character.isLowSurrogate(c1)) {
                    in$2.position(in$2.position() - 1);
                    coderResult = CoderResult.malformedForLength(1);
                    break;
                }
                if (!Character.isHighSurrogate(c1)) {
                    if (out$2.remaining() < 2) {
                        in$2.position(in$2.position() - 1);
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    Encoder.putChar$1(c1, out$2, bigEndian$2);
                    continue;
                }
                if (in$2.remaining() < 1) {
                    in$2.position(in$2.position() - 1);
                    coderResult = CoderResult.UNDERFLOW;
                    break;
                }
                char c2 = in$2.get();
                if (!Character.isLowSurrogate(c2)) {
                    in$2.position(in$2.position() - 2);
                    coderResult = CoderResult.malformedForLength(1);
                    break;
                }
                if (out$2.remaining() < 4) {
                    in$2.position(in$2.position() - 2);
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                Encoder.putChar$1(c1, out$2, bigEndian$2);
                Encoder.putChar$1(c2, out$2, bigEndian$2);
            }
            return coderResult;
        }

        public Encoder() {
            if (UTF_16_Common.this == null) {
                throw null;
            }
            super(UTF_16_Common.this, 2.0f, 2.0f, UTF_16_Common.this.scala$scalajs$niocharset$UTF_16_Common$$endianness() == 2 ? (byte[])Array$.MODULE$.apply(Predef$.MODULE$.wrapByteArray(new byte[]{-3, -1}), ClassTag$.MODULE$.Byte()) : (byte[])Array$.MODULE$.apply(Predef$.MODULE$.wrapByteArray(new byte[]{-1, -3}), ClassTag$.MODULE$.Byte()));
            this.needToWriteBOM = UTF_16_Common.this.scala$scalajs$niocharset$UTF_16_Common$$endianness() == 0;
        }
    }
}

