/*
 * Decompiled with CFR 0.152.
 */
package superficial;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import superficial.Edge;
import superficial.EdgePair;
import superficial.EdgePath;
import superficial.EdgePath$;
import superficial.Polygon;
import superficial.PureComplex;
import superficial.Quadrangulation;
import superficial.TwoComplex;
import superficial.Vertex;

public final class Quadrangulation$ {
    public static final Quadrangulation$ MODULE$ = new Quadrangulation$();

    public boolean isQuadrangulation(TwoComplex twoComplex) {
        return twoComplex.faces().forall((Function1<Polygon, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(Quadrangulation$.$anonfun$isQuadrangulation$1(f)));
    }

    public Quadrangulation apply(TwoComplex twoComplex) {
        Predef$.MODULE$.assert(twoComplex.isClosedSurface());
        Predef$.MODULE$.assert(twoComplex.faces().forall((Function1<Polygon, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(Quadrangulation$.$anonfun$apply$1(x$1))));
        return (Quadrangulation)twoComplex;
    }

    public int mod(int m, int n) {
        return (m % n + n) % n;
    }

    public Tuple2<TwoComplex, Tuple2<Function1<EdgePath, EdgePath>, Function1<EdgePath, EdgePath>>> quadrangulate(TwoComplex twoComplex) {
        Predef$.MODULE$.require(twoComplex.isClosedSurface(), (Function0<Object>)(Function0<String> & Serializable)() -> "Algorithm only works for closed surfaces");
        List faceList = twoComplex.faces().toList();
        Object facesWithIndexes = faceList.flatMap((Function1<Polygon, IndexedSeq> & Serializable)f -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), f.boundary().length() - 1).map((Function1<Object, Tuple2> & Serializable)ind -> Quadrangulation$.$anonfun$quadrangulate$3(f, BoxesRunTime.unboxToInt(ind))));
        Object barycentersList = faceList.map((Function1<Polygon, Vertex> & Serializable)x$3 -> Quadrangulation$.createBarycenter$1(x$3));
        Map barycenters = ((IterableOnceOps)faceList.zip((IterableOnce)barycentersList)).toMap($less$colon$less$.MODULE$.refl());
        Map newEdgeMap1 = ((AbstractIterable)((List)facesWithIndexes).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Polygon poly = (Polygon)tuple2._1();
            int j = tuple2._2$mcI$sp();
            Tuple2<Tuple2<Polygon, Integer>, EdgePair> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Tuple2<Polygon, Integer>(poly, BoxesRunTime.boxToInteger(j))), Quadrangulation$.createEdgePairs$1(poly, j));
            return tuple22;
        })).toMap($less$colon$less$.MODULE$.refl());
        Object intermediate = newEdgeMap1.toList().map((Function1<Tuple2, Tuple2> & Serializable)x$4 -> x$4.swap());
        Map reverseEdgeMap = ((AbstractIterable)((List)intermediate).map((Function1<Tuple2, Tuple2> & Serializable)el -> new Tuple2<EdgePair.Oriented, Tuple2<Edge, Edge>>(((EdgePair)el._1()).Negative(), new Tuple2<Edge, Edge>(((Polygon)((Tuple2)el._2())._1()).boundary().apply(((Tuple2)el._2())._2$mcI$sp()).flip(), ((Polygon)((Tuple2)el._2())._1()).boundary().apply(MODULE$.mod(((Tuple2)el._2())._2$mcI$sp() - 1, ((Polygon)((Tuple2)el._2())._1()).boundary().length())))))).toMap($less$colon$less$.MODULE$.refl());
        List vertexList = twoComplex.vertices().toList();
        List edgeList = twoComplex.edges().toList();
        Set newFacesAndEdgePathMaps = (Set)twoComplex.halfEdges().map((Function1<Edge, Tuple2> & Serializable)edge -> this.createFace$1((Edge)edge, newEdgeMap1, twoComplex));
        Set newFaces = (Set)newFacesAndEdgePathMaps.map((Function1<Tuple2, Polygon> & Serializable)el -> (Polygon)el._1());
        Set halfOfEdgePathMap = (Set)newFacesAndEdgePathMaps.map((Function1<Tuple2, Tuple2> & Serializable)el -> (Tuple2)el._2());
        Set otherHalfOfEdgePathMap = (Set)halfOfEdgePathMap.map((Function1<Tuple2, Tuple2> & Serializable)el -> new Tuple2<Edge, EdgePath>(((Edge)el._1()).flip(), ((EdgePath)el._2()).reverse()));
        Map edgeToEdgePathMap = halfOfEdgePathMap.$plus$plus(otherHalfOfEdgePathMap).toMap($less$colon$less$.MODULE$.refl());
        PureComplex quad = new PureComplex(newFaces);
        Predef$.MODULE$.assert(this.isQuadrangulation(quad), (Function0<Object>)(Function0<String> & Serializable)() -> "The result of the algorithm doesn't give a quadragulation");
        return new Tuple2<TwoComplex, Tuple2<Function1<EdgePath, EdgePath>, Function1<EdgePath, EdgePath>>>(quad, new Tuple2<Function1<EdgePath, EdgePath> & Serializable, Function1<EdgePath, EdgePath> & Serializable>((Function1<EdgePath, EdgePath> & Serializable)edgePath -> Quadrangulation$.forwardEdgePathMap$1(edgePath, twoComplex, edgeToEdgePathMap, quad), (Function1<EdgePath, EdgePath> & Serializable)edgePath -> this.backWardEdgePathMap$1((EdgePath)edgePath, quad, twoComplex, reverseEdgeMap)));
    }

    public static final /* synthetic */ boolean $anonfun$isQuadrangulation$1(Polygon f) {
        return f.boundary().length() == 4;
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(Polygon x$1) {
        return x$1.sides() == 4;
    }

    public static final /* synthetic */ Tuple2 $anonfun$quadrangulate$3(Polygon f$1, int ind) {
        return new Tuple2<Polygon, Integer>(f$1, BoxesRunTime.boxToInteger(ind));
    }

    private static final Vertex createBarycenter$1(Polygon face) {
        return new Quadrangulation.BaryCenter(face);
    }

    private static final EdgePair createEdgePairs$1(Polygon face, int index) {
        return new Quadrangulation.QuadEdge(face, index);
    }

    public static final /* synthetic */ boolean $anonfun$quadrangulate$8(Edge edge$1, Polygon x$5) {
        return x$5.boundary().contains(edge$1);
    }

    private static final Polygon faceOfEdge$1(Edge edge, TwoComplex twoComplex$1) {
        Option face;
        Option option = face = twoComplex$1.faces().find((Function1<Polygon, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(Quadrangulation$.$anonfun$quadrangulate$8(edge, x$5)));
        None$ none$ = None$.MODULE$;
        Predef$.MODULE$.assert(option == null ? none$ != null : !option.equals(none$), (Function0<Object>)(Function0<String> & Serializable)() -> "For a closed surface each edge should be in at least one face");
        return (Polygon)face.get();
    }

    private final Tuple2 createFace$1(Edge edge, Map newEdgeMap1$1, TwoComplex twoComplex$1) {
        Polygon face = Quadrangulation$.faceOfEdge$1(edge, twoComplex$1);
        Polygon flipFace = Quadrangulation$.faceOfEdge$1(edge.flip(), twoComplex$1);
        int indexOfEdge = face.boundary().indexOf(edge);
        int indexOfFlip = flipFace.boundary().indexOf(edge.flip());
        int periOfFace = face.boundary().length();
        int periOfFlip = flipFace.boundary().length();
        EdgePath.Append edgePath = new EdgePath.Append(new EdgePath.Append(new EdgePath.Constant(edge.initial()), ((EdgePair)newEdgeMap1$1.apply(new Tuple2<Polygon, Integer>(face, BoxesRunTime.boxToInteger(this.mod(indexOfEdge - 1, periOfFace))))).Negative()), ((EdgePair)newEdgeMap1$1.apply(new Tuple2<Polygon, Integer>(face, BoxesRunTime.boxToInteger(indexOfEdge)))).Positive());
        Quadrangulation.QuadFace newFace = new Quadrangulation.QuadFace(face, flipFace, indexOfEdge, indexOfFlip);
        return new Tuple2<Quadrangulation.QuadFace, Tuple2<Edge, EdgePath.Append>>(newFace, new Tuple2<Edge, EdgePath.Append>(edge, edgePath));
    }

    private static final EdgePath forwardEdgePathMap$1(EdgePath edgePath, TwoComplex twoComplex$1, Map edgeToEdgePathMap$1, PureComplex quad$1) {
        EdgePath edgePath2;
        Predef$.MODULE$.require(edgePath.inTwoComplex(twoComplex$1), (Function0<Object>)(Function0<String> & Serializable)() -> "The given edgepath is not part of the original twoComplex");
        EdgePath edgePath3 = edgePath;
        if (edgePath3 instanceof EdgePath.Constant) {
            EdgePath.Constant constant = (EdgePath.Constant)edgePath3;
            Vertex vertex = constant.initial();
            edgePath2 = new EdgePath.Constant(vertex);
        } else if (edgePath3 instanceof EdgePath.Append) {
            EdgePath.Append append = (EdgePath.Append)edgePath3;
            EdgePath init = append.init();
            Edge last = append.last();
            edgePath2 = Quadrangulation$.forwardEdgePathMap$1(init, twoComplex$1, edgeToEdgePathMap$1, quad$1).$plus$plus((EdgePath)edgeToEdgePathMap$1.apply(last));
        } else {
            throw new MatchError(edgePath3);
        }
        EdgePath.Constant newPath = edgePath2;
        Predef$.MODULE$.assert(newPath.inTwoComplex(quad$1), (Function0<Object>)(Function0<String> & Serializable)() -> "The resulting edgepath is not part of the quadrangulation of the original complex");
        return newPath;
    }

    private final Vector gatherEdgesUsingTurnHelper$1(Edge edge, int turn, Vector accum, TwoComplex twoComplex$1) {
        while (true) {
            Predef$.MODULE$.require(twoComplex$1.edges().contains(edge), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(39).append("The Edge ").append(edge).append(" is not inside the TwoComplex ").append(twoComplex$1).toString());
            Predef$.MODULE$.require(twoComplex$1.isClosedSurface(), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(83).append("gatheEdgesUsingTurnHelper might not work as the TwoComplex ").append(twoComplex$1).append(" is not a closed surface").toString());
            if (turn == 0) break;
            if (turn > 0) {
                accum = (Vector)accum.$colon$plus(edge);
                --turn;
                edge = twoComplex$1.succOpt(edge).get();
                continue;
            }
            accum = (Vector)accum.$colon$plus(edge);
            ++turn;
            edge = twoComplex$1.succOpt(edge).get();
        }
        return accum;
    }

    private final Vector gatherEdgesUsingTurn$1(Edge edge, int turn, Map reverseEdgeMap$1, TwoComplex twoComplex$1) {
        return turn == 0 ? (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$) : (turn > 0 ? this.gatherEdgesUsingTurnHelper$1((Edge)((Tuple2)reverseEdgeMap$1.apply(edge))._1(), turn - 1, (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$), twoComplex$1) : this.gatherEdgesUsingTurnHelper$1((Edge)((Tuple2)reverseEdgeMap$1.apply(edge))._2(), turn - 1, (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$), twoComplex$1));
    }

    private final EdgePath gatherTurnUsingPairOfEdges$1(Edge first, Edge second, PureComplex quad$1, TwoComplex twoComplex$1, Map reverseEdgeMap$1) {
        EdgePath result = EdgePath$.MODULE$.apply(this.gatherEdgesUsingTurn$1(first, quad$1.turnIndex(first, second), reverseEdgeMap$1, twoComplex$1));
        Vertex vertex = result.initial();
        Vertex vertex2 = first.initial();
        Predef$.MODULE$.assert(!(vertex != null ? !vertex.equals(vertex2) : vertex2 != null), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(115).append("The initial vertex ").append(result.initial()).append(" of the result ").append(result).append(" of gatheTurnUsingPairOfEdges is not same as the intial vertex ").append(first.initial()).append(" of the first edge").toString());
        Vertex vertex3 = result.terminal();
        Vertex vertex4 = second.terminal();
        Predef$.MODULE$.assert(!(vertex3 != null ? !vertex3.equals(vertex4) : vertex4 != null), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(124).append("The initial vertex ").append(result.terminal()).append(" of the result ").append(result).append(" of gatheTurnUsingPairOfEdges(").append(first).append(", ").append(second).append(") is not same as the terminal vertex ").append(second.terminal()).append(" of the first edge ").append(second).append(" .").toString());
        Predef$.MODULE$.assert(result.inTwoComplex(twoComplex$1), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(85).append("The result ").append(result).append(" of gatheTurnUsingPairOfEdges(").append(first).append(", ").append(second).append(") is not inside the original TwoComplex ").append(twoComplex$1).append(" .").toString());
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final EdgePath backWardMapHelper$1(EdgePath edgePath, TwoComplex twoComplex$1, PureComplex quad$1, Map reverseEdgeMap$1) {
        void var5_12;
        Predef$.MODULE$.require(edgePath.inTwoComplex(twoComplex$1), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(50).append("The given edgepath ").append(edgePath).append(" is not part of the twoComplex ").append(quad$1).toString());
        Predef$.MODULE$.require(twoComplex$1.vertices().contains(edgePath.initial()), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(58).append("The given edgepath ").append(edgePath).append(" does not start at a pre exsting vertex").toString());
        Predef$.MODULE$.require(twoComplex$1.vertices().contains(edgePath.terminal()), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(56).append("The given edgepath ").append(edgePath).append(" does not end at a pre exsting vertex").toString());
        Predef$.MODULE$.require(EdgePath$.MODULE$.length(edgePath) % 2 == 0, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(58).append("backWardMapHelper does not work for odd length paths like ").append(edgePath).toString());
        boolean bl = false;
        EdgePath.Append append = null;
        EdgePath edgePath2 = edgePath;
        if (edgePath2 instanceof EdgePath.Constant) {
            EdgePath.Constant constant = (EdgePath.Constant)edgePath2;
            Vertex vertex = constant.initial();
            EdgePath.Constant constant2 = new EdgePath.Constant(vertex);
            return var5_12;
        } else {
            if (edgePath2 instanceof EdgePath.Append) {
                bl = true;
                append = (EdgePath.Append)edgePath2;
                EdgePath edgePath3 = append.init();
                if (edgePath3 instanceof EdgePath.Constant) {
                    throw Predef$.MODULE$.$qmark$qmark$qmark();
                }
            }
            if (!bl) throw new MatchError(edgePath2);
            EdgePath edgePath4 = append.init();
            Edge second = append.last();
            if (!(edgePath4 instanceof EdgePath.Append)) throw new MatchError(edgePath2);
            EdgePath.Append append2 = (EdgePath.Append)edgePath4;
            EdgePath init = append2.init();
            Edge first = append2.last();
            EdgePath edgePath5 = this.backWardMapHelper$1(init, twoComplex$1, quad$1, reverseEdgeMap$1).$plus$plus(this.gatherTurnUsingPairOfEdges$1(first, second, quad$1, twoComplex$1, reverseEdgeMap$1));
        }
        return var5_12;
    }

    private static final EdgePath prepareEdgePath$1(EdgePath edgePath, TwoComplex twoComplex$1) {
        EdgePath edgePath2;
        if (edgePath.isLoop()) {
            if (twoComplex$1.vertices().contains(edgePath.initial())) {
                edgePath2 = edgePath;
            } else {
                Predef$.MODULE$.assert(EdgePath$.MODULE$.length(edgePath) >= 1, (Function0<Object>)(Function0<String> & Serializable)() -> StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(new StringBuilder(34).append("The EdgePath ").append(edgePath).append(" is the constant loop").toString()), "on the barycenter $edgePath.initial. Hence it is not possible to make it loop on a pre existing vertex"));
                edgePath2 = edgePath.shiftBasePoint();
            }
        } else {
            Predef$.MODULE$.assert(twoComplex$1.vertices().contains(edgePath.terminal()), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(88).append("The EdgePath ").append(edgePath).append(" does not end at a pre existing vertex, so backWardEdgePathMap is not valid").toString());
            Predef$.MODULE$.assert(twoComplex$1.vertices().contains(edgePath.initial()), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(90).append("The EdgePath ").append(edgePath).append(" does not start at a pre existing vertex, so backWardEdgePathMap is not valid").toString());
            edgePath2 = edgePath;
        }
        return edgePath2;
    }

    private final EdgePath backWardEdgePathMap$1(EdgePath edgePath, PureComplex quad$1, TwoComplex twoComplex$1, Map reverseEdgeMap$1) {
        Predef$.MODULE$.require(edgePath.inTwoComplex(quad$1), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(50).append("The given edgepath ").append(edgePath).append(" is not part of the TwoComplex ").append(quad$1).toString());
        EdgePath newPath = this.backWardMapHelper$1(Quadrangulation$.prepareEdgePath$1(edgePath, twoComplex$1), twoComplex$1, quad$1, reverseEdgeMap$1);
        Predef$.MODULE$.assert(newPath.inTwoComplex(twoComplex$1), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(63).append("The resulting edgepath ").append(newPath).append(" is not part of the original TwoComplex ").append(twoComplex$1).toString());
        return newPath;
    }

    private Quadrangulation$() {
    }
}

