/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.Statics;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private static final List<Tuple2<TimeUnit, String>> timeUnitLabels;
    private static final Map<TimeUnit, String> timeUnitName;
    private static final Map<String, TimeUnit> timeUnit;
    private static final FiniteDuration Zero;
    private static final Duration.Infinite Undefined;
    private static final Duration.Infinite Inf;
    private static final Duration.Infinite MinusInf;

    /*
     * WARNING - void declaration
     */
    static {
        Nil$ nil$;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        MODULE$ = new Duration$();
        String $minus$greater$extension_y6 = "d day";
        TimeUnit $minus$greater$extension_$this = TimeUnit.DAYS;
        Object var0_1 = null;
        Object var1 = null;
        String $minus$greater$extension_y7 = "h hour";
        TimeUnit $minus$greater$extension_$this2 = TimeUnit.HOURS;
        Object var2_3 = null;
        Object var3_2 = null;
        String string = "min minute";
        TimeUnit $minus$greater$extension_$this3 = TimeUnit.MINUTES;
        Object var4_5 = null;
        string = null;
        String string2 = "s sec second";
        TimeUnit $minus$greater$extension_$this4 = TimeUnit.SECONDS;
        Object var6_7 = null;
        string2 = null;
        String string3 = "ms milli millisecond";
        TimeUnit $minus$greater$extension_$this5 = TimeUnit.MILLISECONDS;
        Object var8_9 = null;
        string3 = null;
        String string4 = "\u00b5s micro microsecond";
        TimeUnit $minus$greater$extension_$this6 = TimeUnit.MICROSECONDS;
        Object var10_11 = null;
        string4 = null;
        String string5 = "ns nano nanosecond";
        TimeUnit $minus$greater$extension_$this7 = TimeUnit.NANOSECONDS;
        Object var12_13 = null;
        string5 = null;
        timeUnitLabels = new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<TimeUnit, String>($minus$greater$extension_$this, $minus$greater$extension_y6)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<TimeUnit, String>($minus$greater$extension_$this2, $minus$greater$extension_y7)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<TimeUnit, void>($minus$greater$extension_$this3, $minus$greater$extension_y5)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<TimeUnit, void>($minus$greater$extension_$this4, $minus$greater$extension_y4)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<TimeUnit, void>($minus$greater$extension_$this5, $minus$greater$extension_y3)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<TimeUnit, void>($minus$greater$extension_$this6, $minus$greater$extension_y2)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<TimeUnit, void>($minus$greater$extension_$this7, $minus$greater$extension_y)), Nil$.MODULE$)))))));
        timeUnitName = timeUnitLabels.toMap($less$colon$less$.MODULE$.refl()).view().mapValues((Function1<String, String> & Serializable)s2 -> MODULE$.words((String)s2).last()).toMap($less$colon$less$.MODULE$.refl());
        $colon$colon<Nothing$> flatMap_h = null;
        $colon$colon<Nothing$> flatMap_t = null;
        for (List flatMap_rest = timeUnitLabels; flatMap_rest != Nil$.MODULE$; flatMap_rest = (List)flatMap_rest.tail()) {
            Iterator flatMap_it = Duration$.$anonfun$timeUnit$1((Tuple2)flatMap_rest.head()).iterator();
            while (flatMap_it.hasNext()) {
                $colon$colon<Nothing$> flatMap_nx = new $colon$colon<Nothing$>((Nothing$)flatMap_it.next(), Nil$.MODULE$);
                if (flatMap_t == null) {
                    flatMap_h = flatMap_nx;
                } else {
                    flatMap_t.next_$eq(flatMap_nx);
                }
                flatMap_t = flatMap_nx;
            }
        }
        if (flatMap_h == null) {
            nil$ = Nil$.MODULE$;
        } else {
            Statics.releaseFence();
            nil$ = flatMap_h;
        }
        Object var14_14 = null;
        Object var15_15 = null;
        Object var16_16 = null;
        Object var17_17 = null;
        Object var18_18 = null;
        timeUnit = nil$.toMap($less$colon$less$.MODULE$.refl());
        Zero = new FiniteDuration(0L, TimeUnit.DAYS);
        Undefined = new Duration.Infinite(){

            public String toString() {
                return "Duration.Undefined";
            }

            public boolean equals(Object other) {
                return false;
            }

            public Duration $plus(Duration other) {
                return this;
            }

            public Duration $minus(Duration other) {
                return this;
            }

            public Duration $times(double factor) {
                return this;
            }

            public Duration $div(double factor) {
                return this;
            }

            public double $div(Duration other) {
                return Double.NaN;
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return 1;
            }

            public Duration unary_$minus() {
                return this;
            }

            public double toUnit(TimeUnit unit) {
                return Double.NaN;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Undefined();
            }
        };
        Inf = new Duration.Infinite(){

            public String toString() {
                return "Duration.Inf";
            }

            public int compare(Duration other) {
                int n = other == Duration$.MODULE$.Undefined() ? -1 : (other == this ? 0 : 1);
                return n;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.MinusInf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.POSITIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Inf();
            }
        };
        MinusInf = new Duration.Infinite(){

            public String toString() {
                return "Duration.MinusInf";
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return -1;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.Inf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.NEGATIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.MinusInf();
            }
        };
    }

    public Duration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, (TimeUnit)((Object)this.timeUnit().apply(unit)));
    }

    public Duration apply(String s2) {
        Duration duration;
        String string;
        String string2;
        int filterNot$extension_filter$extension_len = s2.length();
        StringBuilder filterNot$extension_filter$extension_sb = new StringBuilder(filterNot$extension_filter$extension_len);
        for (int filterNot$extension_filter$extension_i = 0; filterNot$extension_filter$extension_i < filterNot$extension_filter$extension_len; ++filterNot$extension_filter$extension_i) {
            char filterNot$extension_filter$extension_x = s2.charAt(filterNot$extension_filter$extension_i);
            if (!(!Duration$.$anonfun$apply$1(filterNot$extension_filter$extension_x))) continue;
            filterNot$extension_filter$extension_sb.append(filterNot$extension_filter$extension_x);
        }
        String string3 = string2 = filterNot$extension_filter$extension_len == filterNot$extension_filter$extension_sb.length() ? s2 : filterNot$extension_filter$extension_sb.toString();
        Object var14_3 = null;
        string2 = null;
        String string4 = string = string3;
        string = null;
        String s1 = string4;
        boolean bl = "Inf".equals(s1) ? true : ("PlusInf".equals(s1) ? true : ("+Inf".equals(s1) ? true : "Duration.Inf".equals(s1)));
        if (bl) {
            duration = this.Inf();
        } else {
            boolean bl2 = "MinusInf".equals(s1) ? true : ("-Inf".equals(s1) ? true : "Duration.MinusInf".equals(s1));
            if (bl2) {
                duration = this.MinusInf();
            } else if ("Duration.Undefined".equals(s1)) {
                duration = this.Undefined();
            } else {
                Duration duration2;
                String string5;
                int n;
                String takeWhile$extension_$this;
                block15: {
                    takeWhile$extension_$this = StringOps$.MODULE$.reverse$extension(s1);
                    int n2 = 0;
                    int takeWhile$extension_indexWhere$extension_len = takeWhile$extension_$this.length();
                    for (int takeWhile$extension_indexWhere$extension_i = n2; takeWhile$extension_indexWhere$extension_i < takeWhile$extension_indexWhere$extension_len; ++takeWhile$extension_indexWhere$extension_i) {
                        if (!(!Duration$.$anonfun$apply$2(takeWhile$extension_$this.charAt(takeWhile$extension_indexWhere$extension_i)))) continue;
                        n = takeWhile$extension_indexWhere$extension_i;
                        break block15;
                    }
                    n = -1;
                }
                switch (n) {
                    case -1: {
                        string5 = takeWhile$extension_$this;
                        break;
                    }
                    default: {
                        string5 = takeWhile$extension_$this.substring(0, n);
                    }
                }
                Object var19_12 = null;
                String unitName = StringOps$.MODULE$.reverse$extension(string5);
                Option option = this.timeUnit().get(unitName);
                if (option instanceof Some) {
                    TimeUnit unit = (TimeUnit)((Object)((Some)option).value());
                    String valueStr = StringOps$.MODULE$.dropRight$extension(s1, unitName.length());
                    double valueD = Double.parseDouble(valueStr);
                    if (valueD >= -9.007199254740992E15 && valueD <= 9.007199254740992E15) {
                        duration2 = this.apply(valueD, unit);
                    } else {
                        long apply_length = Long.parseLong(valueStr);
                        FiniteDuration finiteDuration = new FiniteDuration(apply_length, unit);
                        duration2 = finiteDuration;
                        finiteDuration = null;
                    }
                } else {
                    throw new NumberFormatException(new StringBuilder(13).append("format error ").append(s2).toString());
                }
                Duration duration3 = duration2;
                duration = duration3;
            }
        }
        return duration;
    }

    private List<String> words(String s2) {
        ArraySeq.ofRef<String> ofRef2 = Predef$.MODULE$.wrapRefArray(s2.trim().split("\\s+"));
        if (ofRef2 == null) {
            throw null;
        }
        ArraySeq.ofRef<String> toList_this = ofRef2;
        return List$.MODULE$.from(toList_this);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> expandLabels(String labels) {
        void var4_4;
        Nil$ nil$;
        Nil$ nil$2;
        void var5_5;
        List<String> list = this.words(labels);
        if (!(list instanceof $colon$colon)) {
            throw new MatchError(list);
        }
        $colon$colon $colon$colon = ($colon$colon)list;
        String hd = (String)$colon$colon.head();
        List rest = $colon$colon.next$access$1();
        if (var5_5 == null) {
            throw null;
        }
        $colon$colon<Nothing$> flatMap_h = null;
        $colon$colon<Nothing$> flatMap_t = null;
        for (List flatMap_rest = var5_5; flatMap_rest != Nil$.MODULE$; flatMap_rest = (List)flatMap_rest.tail()) {
            Iterator flatMap_it = Duration$.$anonfun$expandLabels$1((String)flatMap_rest.head()).iterator();
            while (flatMap_it.hasNext()) {
                $colon$colon<Nothing$> flatMap_nx = new $colon$colon<Nothing$>((Nothing$)flatMap_it.next(), Nil$.MODULE$);
                if (flatMap_t == null) {
                    flatMap_h = flatMap_nx;
                } else {
                    flatMap_t.next_$eq(flatMap_nx);
                }
                flatMap_t = flatMap_nx;
            }
        }
        if (flatMap_h == null) {
            nil$2 = Nil$.MODULE$;
        } else {
            Statics.releaseFence();
            nil$2 = flatMap_h;
        }
        Nil$ nil$3 = nil$ = nil$2;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        nil$ = null;
        Nil$ $colon$colon_this = nil$3;
        return new $colon$colon<Nothing$>((Nothing$)var4_4, $colon$colon_this);
    }

    public Map<TimeUnit, String> timeUnitName() {
        return timeUnitName;
    }

    public Map<String, TimeUnit> timeUnit() {
        return timeUnit;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(String s2) {
        Option option;
        try {
            option = new Some<Duration>(this.apply(s2));
        }
        catch (RuntimeException runtimeException) {
            option = None$.MODULE$;
        }
        return option.flatMap((Function1<Duration, Option> & Serializable)d -> MODULE$.unapply((Duration)d));
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        if (d.isFinite()) {
            return new Some<Tuple2<Object, TimeUnit>>(new Tuple2<Long, TimeUnit>(d.length(), d.unit()));
        }
        return None$.MODULE$;
    }

    public Duration fromNanos(double nanos) {
        if (Double.valueOf(nanos).isInfinite()) {
            if (nanos > 0.0) {
                return this.Inf();
            }
            return this.MinusInf();
        }
        if (Double.isNaN(nanos)) {
            return this.Undefined();
        }
        if (nanos > (double)Long.MAX_VALUE || nanos < (double)Long.MIN_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(46).append("trying to construct too large duration with ").append(nanos).append("ns").toString());
        }
        return this.fromNanos(Math.round(nanos));
    }

    /*
     * WARNING - void declaration
     */
    public FiniteDuration fromNanos(long nanos) {
        if (nanos % 86400000000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.DAYS;
            long apply_length = nanos / 86400000000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 3600000000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.HOURS;
            long apply_length = nanos / 3600000000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 60000000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.MINUTES;
            long apply_length = nanos / 60000000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 1000000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.SECONDS;
            long apply_length = nanos / 1000000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 1000000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            long apply_length = nanos / 1000000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        if (nanos % 1000L == 0L) {
            void apply_unit;
            TimeUnit timeUnit = TimeUnit.MICROSECONDS;
            long apply_length = nanos / 1000L;
            return new FiniteDuration(apply_length, (TimeUnit)apply_unit);
        }
        TimeUnit apply_unit = TimeUnit.NANOSECONDS;
        return new FiniteDuration(nanos, apply_unit);
    }

    public FiniteDuration Zero() {
        return Zero;
    }

    public Duration.Infinite Undefined() {
        return Undefined;
    }

    public Duration.Infinite Inf() {
        return Inf;
    }

    public Duration.Infinite MinusInf() {
        return MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public Duration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration create(String s2) {
        return this.apply(s2);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Duration$.class);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(char x$1) {
        return Character.isWhitespace(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(char x$2) {
        return Character.isLetter(x$2);
    }

    public static final /* synthetic */ List $anonfun$expandLabels$1(String s2) {
        return new $colon$colon<Nothing$>((Nothing$)((Object)s2), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(1).append(s2).append("s").toString()), Nil$.MODULE$));
    }

    public static final /* synthetic */ Tuple2 $anonfun$timeUnit$2(TimeUnit unit$1, String x$4) {
        return new Tuple2<String, TimeUnit>(x$4, unit$1);
    }

    public static final /* synthetic */ List $anonfun$timeUnit$1(Tuple2 x0$1) {
        Nil$ nil$;
        List list;
        if (x0$1 != null) {
            TimeUnit unit = (TimeUnit)((Object)x0$1._1());
            String names = (String)x0$1._2();
            List<String> list2 = MODULE$.expandLabels(names);
            if (list2 == null) {
                throw null;
            }
            List<String> map_this = list2;
            if (map_this == Nil$.MODULE$) {
                list = Nil$.MODULE$;
            } else {
                $colon$colon<Nothing$> map_h;
                String string = (String)map_this.head();
                $colon$colon<Nothing$> map_t = map_h = new $colon$colon<Nothing$>((Nothing$)((Object)Duration$.$anonfun$timeUnit$2(unit, string)), Nil$.MODULE$);
                for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    string = (String)map_rest.head();
                    $colon$colon<Nothing$> map_nx = new $colon$colon<Nothing$>((Nothing$)((Object)Duration$.$anonfun$timeUnit$2(unit, string)), Nil$.MODULE$);
                    map_t.next_$eq(map_nx);
                    map_t = map_nx;
                }
                Statics.releaseFence();
                list = map_h;
            }
        } else {
            throw new MatchError((Object)null);
        }
        Nil$ nil$2 = nil$ = list;
        Object var4_3 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        nil$ = null;
        Nil$ nil$3 = nil$2;
        return nil$3;
    }

    private Duration$() {
    }

    public static final /* synthetic */ Object $anonfun$apply$1$adapted(Object x$1) {
        return BoxesRunTime.boxToBoolean(Duration$.$anonfun$apply$1(BoxesRunTime.unboxToChar(x$1)));
    }

    public static final /* synthetic */ Object $anonfun$apply$2$adapted(Object x$2) {
        return BoxesRunTime.boxToBoolean(Duration$.$anonfun$apply$2(BoxesRunTime.unboxToChar(x$2)));
    }
}

