/*
 * Decompiled with CFR 0.152.
 */
package scala.scalajs.js;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.Array$;
import scala.scalajs.js.ArrayOps;
import scala.scalajs.js.ArrayOpsCommon$;
import scala.scalajs.js.JSConverters$;
import scala.scalajs.js.JSConverters$JSRichIterableOnce$;
import scala.scalajs.js.WrappedArray;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ArrayOps$ {
    public static final ArrayOps$ MODULE$ = new ArrayOps$();

    public final <A> int size$extension(Array<A> $this) {
        return $this.length();
    }

    public final <A> int knownSize$extension(Array<A> $this) {
        return $this.length();
    }

    public final <A> boolean isEmpty$extension(Array<A> $this) {
        return $this.length() == 0;
    }

    public final <A> boolean nonEmpty$extension(Array<A> $this) {
        return $this.length() != 0;
    }

    public final <A> A head$extension(Array<A> $this) {
        if (this.isEmpty$extension($this)) {
            throw new NoSuchElementException("head of empty array");
        }
        return $this.apply(0);
    }

    public final <A> A last$extension(Array<A> $this) {
        if (this.isEmpty$extension($this)) {
            throw new NoSuchElementException("last of empty array");
        }
        return $this.apply($this.length() - 1);
    }

    public final <A> Option<A> headOption$extension(Array<A> $this) {
        return this.isEmpty$extension($this) ? None$.MODULE$ : new Some<A>($this.apply(0));
    }

    public final <A> Option<A> lastOption$extension(Array<A> $this) {
        return this.isEmpty$extension($this) ? None$.MODULE$ : new Some<A>($this.apply($this.length() - 1));
    }

    public final <A> int sizeCompare$extension(Array<A> $this, int otherSize) {
        return Integer.compare($this.length(), otherSize);
    }

    public final <A> int lengthCompare$extension(Array<A> $this, int len) {
        return Integer.compare($this.length(), len);
    }

    public final <A> int sizeIs$extension(Array<A> $this) {
        return $this.length();
    }

    public final <A> int lengthIs$extension(Array<A> $this) {
        return $this.length();
    }

    public final <A> Array<A> slice$extension(Array<A> $this, int from, int until) {
        return $this.jsSlice(Math.max(from, 0), Math.max(until, 0));
    }

    public final <A> Array<A> tail$extension(Array<A> $this) {
        if (this.isEmpty$extension($this)) {
            throw new UnsupportedOperationException("tail of empty array");
        }
        return $this.jsSlice(1, $this.jsSlice$default$2());
    }

    public final <A> Array<A> init$extension(Array<A> $this) {
        if (this.isEmpty$extension($this)) {
            throw new UnsupportedOperationException("init of empty array");
        }
        return $this.jsSlice(0, -1);
    }

    public final <A> Iterator<Array<A>> tails$extension(Array<A> $this) {
        return this.iterateUntilEmpty$extension($this, (Function1<Array, Array> & Serializable)x$1 -> MODULE$.tail$extension(Any$.MODULE$.jsArrayOps(x$1)));
    }

    public final <A> Iterator<Array<A>> inits$extension(Array<A> $this) {
        return this.iterateUntilEmpty$extension($this, (Function1<Array, Array> & Serializable)x$2 -> MODULE$.init$extension(Any$.MODULE$.jsArrayOps(x$2)));
    }

    public final <A> Iterator<Array<A>> iterateUntilEmpty$extension(Array<A> $this, Function1<Array<A>, Array<A>> f) {
        return Iterator$.MODULE$.iterate($this, f).takeWhile((Function1<Array, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(ArrayOps$.MODULE$.nonEmpty$extension(Any$.MODULE$.jsArrayOps(x$3)))).$plus$plus((Function0<Iterator> & Serializable)() -> Iterator$.MODULE$.single(Array$.MODULE$.apply(Nil$.MODULE$)));
    }

    public final <A> Array<A> take$extension(Array<A> $this, int n) {
        return $this.jsSlice(0, Math.max(n, 0));
    }

    public final <A> Array<A> drop$extension(Array<A> $this, int n) {
        return $this.jsSlice(Math.max(n, 0), $this.jsSlice$default$2());
    }

    public final <A> Array<A> takeRight$extension(Array<A> $this, int n) {
        return n <= 0 ? Array$.MODULE$.apply(Nil$.MODULE$) : $this.jsSlice(-n, $this.jsSlice$default$2());
    }

    public final <A> Array<A> dropRight$extension(Array<A> $this, int n) {
        return n <= 0 ? $this.jsSlice($this.jsSlice$default$1(), $this.jsSlice$default$2()) : $this.jsSlice(0, -n);
    }

    public final <A> Array<A> takeWhile$extension(Array<A> $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$takeWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        return i < 0 ? $this.jsSlice($this.jsSlice$default$1(), $this.jsSlice$default$2()) : $this.jsSlice(0, i);
    }

    public final <A> Array<A> dropWhile$extension(Array<A> $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$dropWhile$1(p, x)), this.indexWhere$default$2$extension($this));
        return i < 0 ? Array$.MODULE$.apply(Nil$.MODULE$) : $this.jsSlice(i, $this.jsSlice$default$2());
    }

    public final <A> Iterator<A> iterator$extension(Array<A> $this) {
        return new ArrayOps.ArrayIterator<A>($this);
    }

    public final <A> Iterator<Array<A>> grouped$extension(Array<A> $this, int size) {
        return new ArrayOps.GroupedIterator<A>($this, size);
    }

    public final <A> Tuple2<Array<A>, Array<A>> span$extension(Array<A> $this, Function1<A, Object> p) {
        int i = this.indexWhere$extension($this, (Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$span$1(p, x)), this.indexWhere$default$2$extension($this));
        int idx = i < 0 ? $this.length() : i;
        return new Tuple2<Array<A>, Array<A>>($this.jsSlice(0, idx), $this.jsSlice(idx, $this.jsSlice$default$2()));
    }

    public final <A> Tuple2<Array<A>, Array<A>> splitAt$extension(Array<A> $this, int n) {
        return new Tuple2<Array<A>, Array<A>>(this.take$extension($this, n), this.drop$extension($this, n));
    }

    public final <A> Tuple2<Array<A>, Array<A>> partition$extension(Array<A> $this, Function1<A, Object> p) {
        Array<Nothing$> res1 = Array$.MODULE$.apply(Nil$.MODULE$);
        Array<Nothing$> res2 = Array$.MODULE$.apply(Nil$.MODULE$);
        this.foreach$extension(Any$.MODULE$.jsArrayOps($this), (Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToInteger(ArrayOps$.$anonfun$partition$1(p, res1, res2, x)));
        return new Tuple2<Array<A>, Array<A>>(res1, res2);
    }

    public final <A1, A2, A> Tuple2<Array<A1>, Array<A2>> partitionMap$extension(Array<A> $this, Function1<A, Either<A1, A2>> f) {
        Array<Nothing$> res1 = Array$.MODULE$.apply(Nil$.MODULE$);
        Array<Nothing$> res2 = Array$.MODULE$.apply(Nil$.MODULE$);
        this.foreach$extension(Any$.MODULE$.jsArrayOps($this), (Function1<Object, Array> & Serializable)x -> {
            Array array;
            Either either = (Either)f.apply(x);
            if (either instanceof Left) {
                Left left = (Left)either;
                Object y = left.value();
                array = MODULE$.$plus$eq$extension(Any$.MODULE$.jsArrayOps(res1), y);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Object y = right.value();
                array = MODULE$.$plus$eq$extension(Any$.MODULE$.jsArrayOps(res2), y);
            } else {
                throw new MatchError(either);
            }
            return array;
        });
        return new Tuple2<Array<A1>, Array<A2>>(res1, res2);
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Array<A> reverse$extension(Array<A> $this) {
        void var3_3;
        int len = $this.length();
        Array<A> res = new Array<A>(len);
        for (int i = 0; i < len; ++i) {
            res.update(len - i - 1, $this.apply(i));
        }
        return var3_3;
    }

    public final <A> Iterator<A> reverseIterator$extension(Array<A> $this) {
        return new ArrayOps.ReverseIterator<A>($this);
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Array<A> filter$extension(Array<A> $this, Function1<A, Object> p) {
        void var3_3;
        Array<Nothing$> res = Array$.MODULE$.apply(Nil$.MODULE$);
        this.foreach$extension(Any$.MODULE$.jsArrayOps($this), (Function1<Object, Object> & Serializable)x -> BoxesRunTime.unboxToBoolean(p.apply(x)) ? BoxesRunTime.boxToInteger(res.push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{x}))) : BoxedUnit.UNIT);
        return var3_3;
    }

    public final <A> Array<A> filterNot$extension(Array<A> $this, Function1<A, Object> p) {
        return this.filter$extension($this, (Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$filterNot$1(p, x)));
    }

    public final <B, A> Array<A> sorted$extension(Array<A> $this, Ordering<B> ord) {
        return ((WrappedArray)new WrappedArray<A>($this).sorted((Ordering)ord)).array();
    }

    public final <A> Array<A> sortWith$extension(Array<A> $this, Function2<A, A, Object> lt) {
        return this.sorted$extension($this, package$.MODULE$.Ordering().fromLessThan(lt));
    }

    public final <B, A> Array<A> sortBy$extension(Array<A> $this, Function1<A, B> f, Ordering<B> ord) {
        return this.sorted$extension($this, ord.on(f));
    }

    public final <A> ArrayOps.WithFilter<A> withFilter$extension(Array<A> $this, Function1<A, Object> p) {
        return new ArrayOps.WithFilter<A>(p, $this);
    }

    public final <A> int indexOf$extension(Array<A> $this, A elem, int from) {
        return this.indexWhere$extension($this, (Function1<Object, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$indexOf$1(elem, x$4)), from);
    }

    public final <A> int indexOf$default$2$extension(Array<A> $this) {
        return 0;
    }

    public final <A> int indexWhere$extension(Array<A> $this, Function1<A, Object> f, int from) {
        int len = $this.length();
        for (int i = from; i < len; ++i) {
            if (!BoxesRunTime.unboxToBoolean(f.apply($this.apply(i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int indexWhere$default$2$extension(Array<A> $this) {
        return 0;
    }

    public final <A> int lastIndexOf$extension(Array<A> $this, A elem, int end) {
        return this.lastIndexWhere$extension($this, (Function1<Object, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$lastIndexOf$1(elem, x$5)), end);
    }

    public final <A> int lastIndexOf$default$2$extension(Array<A> $this) {
        return $this.length() - 1;
    }

    public final <A> int lastIndexWhere$extension(Array<A> $this, Function1<A, Object> p, int end) {
        for (int i = Math.min(end, $this.length() - 1); i >= 0; --i) {
            if (!BoxesRunTime.unboxToBoolean(p.apply($this.apply(i)))) continue;
            return i;
        }
        return -1;
    }

    public final <A> int lastIndexWhere$default$2$extension(Array<A> $this) {
        return $this.length() - 1;
    }

    public final <A> Option<A> find$extension(Array<A> $this, Function1<A, Object> f) {
        int idx = this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this));
        return idx == -1 ? None$.MODULE$ : new Some<A>($this.apply(idx));
    }

    public final <A> boolean exists$extension(Array<A> $this, Function1<A, Object> f) {
        return this.indexWhere$extension($this, f, this.indexWhere$default$2$extension($this)) >= 0;
    }

    public final <A> boolean forall$extension(Array<A> $this, Function1<A, Object> f) {
        int len = $this.length();
        for (int i = 0; i < len; ++i) {
            if (BoxesRunTime.unboxToBoolean(f.apply($this.apply(i)))) continue;
            return false;
        }
        return true;
    }

    public final <B, A> B foldLeft$extension(Array<A> $this, B z, Function2<B, A, B> op) {
        ObjectRef v = ObjectRef.create(z);
        this.foreach$extension(Any$.MODULE$.jsArrayOps($this), (Function1<Object, Object> & Serializable)x -> {
            v.elem = op.apply(v.elem, x);
            return BoxedUnit.UNIT;
        });
        return (B)v.elem;
    }

    public final <B, A> Array<B> scanLeft$extension(Array<A> $this, B z, Function2<B, A, B> op) {
        int i;
        int len = $this.length();
        B v = z;
        Array<B> res = new Array<B>(len + 1);
        for (i = 0; i < len; ++i) {
            res.update(i, v);
            v = op.apply(v, $this.apply(i));
        }
        res.update(i, v);
        return res;
    }

    public final <B, A> Array<B> scan$extension(Array<A> $this, B z, Function2<B, B, B> op) {
        return this.scanLeft$extension($this, z, op);
    }

    public final <B, A> Array<B> scanRight$extension(Array<A> $this, B z, Function2<A, B, B> op) {
        int len = $this.length();
        B v = z;
        Array<B> res = new Array<B>(len + 1);
        res.update(len, z);
        for (int i = len - 1; i >= 0; --i) {
            v = op.apply($this.apply(i), v);
            res.update(i, v);
        }
        return res;
    }

    public final <B, A> B foldRight$extension(Array<A> $this, B z, Function2<A, B, B> op) {
        B v = z;
        for (int i = $this.length() - 1; i >= 0; --i) {
            v = op.apply($this.apply(i), v);
        }
        return v;
    }

    public final <A1, A> A1 fold$extension(Array<A> $this, A1 z, Function2<A1, A1, A1> op) {
        Object object;
        int len = $this.length();
        if (len > 0) {
            Object v = $this.apply(0);
            for (int i = 1; i < len; ++i) {
                v = op.apply(v, $this.apply(i));
            }
            object = v;
        } else {
            object = z;
        }
        return object;
    }

    public final <B, A> Array<B> map$extension(Array<A> $this, Function1<A, B> f) {
        int len = $this.length();
        Array<B> res = new Array<B>(len);
        for (int i = 0; i < len; ++i) {
            res.update(i, f.apply($this.apply(i)));
        }
        return res;
    }

    public final <A> Array<A> mapInPlace$extension(Array<A> $this, Function1<A, A> f) {
        int len = $this.length();
        for (int i = 0; i < len; ++i) {
            $this.update(i, f.apply($this.apply(i)));
        }
        return $this;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Array<B> flatMap$extension(Array<A> $this, Function1<A, IterableOnce<B>> f) {
        void var3_3;
        Array<Nothing$> b2 = Array$.MODULE$.apply(Nil$.MODULE$);
        this.foreach$extension(Any$.MODULE$.jsArrayOps($this), (Function1<Object, Array> & Serializable)x -> MODULE$.$plus$plus$eq$extension(Any$.MODULE$.jsArrayOps(b2), (IterableOnce)f.apply(x)));
        return var3_3;
    }

    public final <BS, B, A> Array<B> flatMap$extension(Array<A> $this, Function1<A, BS> f, Function1<BS, Iterable<B>> asIterable) {
        return this.flatMap$extension($this, (Function1<Object, Iterable> & Serializable)x -> (Iterable)asIterable.apply(f.apply(x)));
    }

    public final <B, A> Array<B> flatten$extension(Array<A> $this, Function1<A, Iterable<B>> asIterable) {
        return this.flatMap$extension($this, (Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x), asIterable);
    }

    public final <B, A> Array<B> collect$extension(Array<A> $this, PartialFunction<A, B> pf) {
        BooleanRef matched = BooleanRef.create(true);
        Array<Nothing$> b2 = Array$.MODULE$.apply(Nil$.MODULE$);
        this.foreach$extension(Any$.MODULE$.jsArrayOps($this), (Function1<Object, Object> & Serializable)x2 -> {
            matched$1.elem = true;
            Object v = pf.applyOrElse(x2, (Function1<Object, Object> & Serializable)x -> ArrayOps$.d$1(x, matched));
            return matched$1.elem ? BoxesRunTime.boxToInteger(b2.push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{v}))) : BoxedUnit.UNIT;
        });
        return b2;
    }

    public final <B, A> Option<B> collectFirst$extension(Array<A> $this, PartialFunction<A, B> f) {
        BooleanRef matched = BooleanRef.create(true);
        int len = $this.length();
        for (int i = 0; i < len; ++i) {
            matched.elem = true;
            Object v = f.applyOrElse($this.apply(i), (Function1<Object, Object> & Serializable)x -> ArrayOps$.d$2(x, matched));
            if (!matched.elem) continue;
            return new Some(v);
        }
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Array<Tuple2<A, B>> zip$extension(Array<A> $this, IterableOnce<B> that) {
        void var3_3;
        Array<Nothing$> b2 = Array$.MODULE$.apply(Nil$.MODULE$);
        int len = $this.length();
        Iterator<B> it = that.iterator();
        for (int i = 0; i < len && it.hasNext(); ++i) {
            b2.push(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<A, B>($this.apply(i), it.next())}));
        }
        return var3_3;
    }

    public final <A1, B, A> Array<Tuple2<A1, B>> zipAll$extension(Array<A> $this, Iterable<B> that, A1 thisElem, B thatElem) {
        int i;
        Array<Nothing$> b2 = Array$.MODULE$.apply(Nil$.MODULE$);
        int len = $this.length();
        Iterator it = that.iterator();
        for (i = 0; i < len && it.hasNext(); ++i) {
            b2.push(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2($this.apply(i), it.next())}));
        }
        while (it.hasNext()) {
            b2.push(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(thisElem, it.next())}));
            ++i;
        }
        while (i < len) {
            b2.push(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<A, B>($this.apply(i), thatElem)}));
            ++i;
        }
        return b2;
    }

    /*
     * WARNING - void declaration
     */
    public final <A> Array<Tuple2<A, Object>> zipWithIndex$extension(Array<A> $this) {
        void var3_3;
        int len = $this.length();
        Array<Tuple2<A, Integer>> b2 = new Array<Tuple2<A, Integer>>(len);
        for (int i = 0; i < len; ++i) {
            b2.update(i, new Tuple2<A, Integer>($this.apply(i), BoxesRunTime.boxToInteger(i)));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Array<B> appended$extension(Array<A> $this, B x) {
        void var3_3;
        Array dest = $this.jsSlice($this.jsSlice$default$1(), $this.jsSlice$default$2());
        dest.push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{x}));
        return var3_3;
    }

    public final <B, A> Array<B> $colon$plus$extension(Array<A> $this, B x) {
        return this.appended$extension($this, x);
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Array<B> prepended$extension(Array<A> $this, B x) {
        void var3_3;
        Array dest = $this.jsSlice($this.jsSlice$default$1(), $this.jsSlice$default$2());
        dest.unshift(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{x}));
        return var3_3;
    }

    public final <B, A> Array<B> $plus$colon$extension(Array<A> $this, B x) {
        return this.prepended$extension($this, x);
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Array<B> prependedAll$extension(Array<A> $this, IterableOnce<B> prefix) {
        void var3_3;
        Array<Nothing$> b2 = Array$.MODULE$.apply(Nil$.MODULE$);
        this.addAll$extension(Any$.MODULE$.jsArrayOps(b2), prefix);
        this.addAll$extension(Any$.MODULE$.jsArrayOps(b2), Any$.MODULE$.wrapArray($this));
        return var3_3;
    }

    public final <B, A> Array<B> prependedAll$extension(Array<A> $this, Array<? extends B> prefix) {
        return ArrayOpsCommon$.MODULE$.concat(prefix, $this);
    }

    public final <B, A> Array<B> $plus$plus$colon$extension(Array<A> $this, IterableOnce<B> prefix) {
        return this.prependedAll$extension($this, prefix);
    }

    public final <B, A> Array<B> $plus$plus$colon$extension(Array<A> $this, Array<? extends B> prefix) {
        return this.prependedAll$extension($this, prefix);
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Array<B> appendedAll$extension(Array<A> $this, IterableOnce<B> suffix) {
        void var3_3;
        Array<A> b2 = $this.jsSlice($this.jsSlice$default$1(), $this.jsSlice$default$2());
        this.addAll$extension(Any$.MODULE$.jsArrayOps(b2), suffix);
        return var3_3;
    }

    public final <B, A> Array<B> appendedAll$extension(Array<A> $this, Array<? extends B> suffix) {
        return ArrayOpsCommon$.MODULE$.concat($this, suffix);
    }

    public final <B, A> Array<B> $colon$plus$plus$extension(Array<A> $this, IterableOnce<B> suffix) {
        return this.appendedAll$extension($this, suffix);
    }

    public final <B, A> Array<B> $colon$plus$plus$extension(Array<A> $this, Array<? extends B> suffix) {
        return this.appendedAll$extension($this, suffix);
    }

    public final <B, A> Array<B> $plus$plus$extension(Array<A> $this, IterableOnce<B> ys) {
        return this.appendedAll$extension($this, ys);
    }

    public final <B, A> Array<B> $plus$plus$extension(Array<A> $this, Array<? extends B> ys) {
        return this.appendedAll$extension($this, ys);
    }

    public final <A> boolean contains$extension(Array<A> $this, A elem) {
        return this.indexOf$extension($this, elem, this.indexOf$default$2$extension($this)) >= 0;
    }

    public final <B, A> Array<B> patch$extension(Array<A> $this, int from, IterableOnce<B> other, int replaced) {
        int len = $this.length();
        int cut = from > 0 ? Math.min(from, len) : 0;
        Array<A> b2 = $this.jsSlice(0, cut);
        this.$plus$plus$eq$extension(Any$.MODULE$.jsArrayOps(b2), other);
        for (int i = cut + Math.max(replaced, 0); i < len; ++i) {
            this.$plus$eq$extension(Any$.MODULE$.jsArrayOps(b2), $this.apply(i));
        }
        return b2;
    }

    public final <A1, A2, A> Tuple2<Array<A1>, Array<A2>> unzip$extension(Array<A> $this, Function1<A, Tuple2<A1, A2>> asPair) {
        int len = $this.length();
        Array<A1> a1 = new Array<A1>(len);
        Array<A2> a2 = new Array<A2>(len);
        for (int i = 0; i < len; ++i) {
            Tuple2<A1, A2> e = asPair.apply($this.apply(i));
            a1.update(i, e._1());
            a2.update(i, e._2());
        }
        return new Tuple2<Array<A1>, Array<A2>>(a1, a2);
    }

    public final <A1, A2, A3, A> Tuple3<Array<A1>, Array<A2>, Array<A3>> unzip3$extension(Array<A> $this, Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        int len = $this.length();
        Array<A1> a1 = new Array<A1>(len);
        Array<A2> a2 = new Array<A2>(len);
        Array<A3> a3 = new Array<A3>(len);
        for (int i = 0; i < len; ++i) {
            Tuple3<A1, A2, A3> e = asTriple.apply($this.apply(i));
            a1.update(i, e._1());
            a2.update(i, e._2());
            a3.update(i, e._3());
        }
        return new Tuple3<Array<A1>, Array<A2>, Array<A3>>(a1, a2, a3);
    }

    public final <B, A> Array<Array<B>> transpose$extension(Array<A> $this, Function1<A, Array<B>> asArray) {
        Array<Nothing$> array;
        int xsLen = $this.length();
        if (xsLen > 0) {
            Array<B> bs = this.map$extension(Any$.MODULE$.jsArrayOps(asArray.apply($this.apply(0))), (Function1<Object, Array> & Serializable)x -> Array$.MODULE$.apply(Nil$.MODULE$));
            for (int i = 0; i < xsLen; ++i) {
                Array<B> ys = asArray.apply($this.apply(i));
                int ysLen = ys.length();
                for (int j = 0; j < ysLen; ++j) {
                    ((Array)bs.apply(j)).push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{ys.apply(j)}));
                }
            }
            array = bs;
        } else {
            array = Array$.MODULE$.apply(Nil$.MODULE$);
        }
        return array;
    }

    public final <U, A> void foreach$extension(Array<A> $this, Function1<A, U> f) {
        int len = $this.length();
        for (int i = 0; i < len; ++i) {
            f.apply($this.apply(i));
        }
    }

    public final <A> Array<A> distinct$extension(Array<A> $this) {
        return this.distinctBy$extension($this, (Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Array<A> distinctBy$extension(Array<A> $this, Function1<A, B> f) {
        void var3_3;
        Array<Nothing$> result = Array$.MODULE$.apply(Nil$.MODULE$);
        this.addAll$extension(Any$.MODULE$.jsArrayOps(result), this.iterator$extension($this).distinctBy(f));
        return var3_3;
    }

    public final <B, A> Array<B> padTo$extension(Array<A> $this, int len, B elem) {
        Array dest = $this.jsSlice($this.jsSlice$default$1(), $this.jsSlice$default$2());
        for (int i = $this.length(); i < len; ++i) {
            dest.push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{elem}));
        }
        return dest;
    }

    public final <A> Range indices$extension(Array<A> $this) {
        return package$.MODULE$.Range().apply(0, $this.length());
    }

    public final <K, A> Map<K, Array<A>> groupBy$extension(Array<A> $this, Function1<A, K> f) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.foreach$extension(Any$.MODULE$.jsArrayOps($this), (Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToInteger(ArrayOps$.$anonfun$groupBy$1(f, m, x)));
        return m.toMap($less$colon$less$.MODULE$.refl());
    }

    public final <K, B, A> Map<K, Array<B>> groupMap$extension(Array<A> $this, Function1<A, K> key, Function1<A, B> f) {
        scala.collection.mutable.Map m = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.foreach$extension(Any$.MODULE$.jsArrayOps($this), (Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToInteger(ArrayOps$.$anonfun$groupMap$1(key, m, f, x)));
        return m.toMap($less$colon$less$.MODULE$.refl());
    }

    public final <A> Seq<A> toSeq$extension(Array<A> $this) {
        return this.toIndexedSeq$extension($this);
    }

    public final <A> IndexedSeq<A> toIndexedSeq$extension(Array<A> $this) {
        return IndexedSeq$.MODULE$.from((IterableOnce)Any$.MODULE$.wrapArray($this));
    }

    public final <B, A> int copyToArray$extension(Array<A> $this, Object xs) {
        return this.copyToArray$extension($this, xs, 0);
    }

    public final <B, A> int copyToArray$extension(Array<A> $this, Object xs, int start) {
        return this.copyToArray$extension($this, xs, start, Integer.MAX_VALUE);
    }

    public final <B, A> int copyToArray$extension(Array<A> $this, Object xs, int start, int len) {
        Array<A> src = $this;
        Object dest = xs;
        int copied = ArrayOps$.elemsToCopyToArray$1(src.length(), ScalaRunTime$.MODULE$.array_length(dest), start, len);
        for (int i = 0; i < copied; ++i) {
            ScalaRunTime$.MODULE$.array_update(dest, i + start, src.apply(i));
        }
        return copied;
    }

    /*
     * WARNING - void declaration
     */
    public final <B, A> Object toArray$extension(Array<A> $this, ClassTag<B> evidence$1) {
        void var3_3;
        Object destination = evidence$1.newArray($this.length());
        this.copyToArray$extension($this, destination, 0);
        return var3_3;
    }

    public final <A> int count$extension(Array<A> $this, Function1<A, Object> p) {
        IntRef res = IntRef.create(0);
        this.foreach$extension(Any$.MODULE$.jsArrayOps($this), (Function1<Object, Object> & Serializable)x -> {
            ArrayOps$.$anonfun$count$1(p, res, x);
            return BoxedUnit.UNIT;
        });
        return res.elem;
    }

    public final <B, A> boolean startsWith$extension(Array<A> $this, Array<B> that) {
        return this.startsWith$extension($this, that, 0);
    }

    public final <B, A> boolean startsWith$extension(Array<A> $this, Array<B> that, int offset) {
        boolean bl;
        int safeOffset = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(offset), 0);
        int thatl = that.length();
        if (thatl > $this.length() - safeOffset) {
            bl = thatl == 0;
        } else {
            for (int i = 0; i < thatl; ++i) {
                if (BoxesRunTime.equals($this.apply(i + safeOffset), that.apply(i))) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public final <B, A> boolean endsWith$extension(Array<A> $this, Array<B> that) {
        boolean bl;
        int thatl = that.length();
        int off = $this.length() - thatl;
        if (off < 0) {
            bl = false;
        } else {
            for (int i = 0; i < thatl; ++i) {
                if (BoxesRunTime.equals($this.apply(i + off), that.apply(i))) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public final <B, A> Array<B> updated$extension(Array<A> $this, int index, B elem) {
        if (index < 0 || index >= $this.length()) {
            throw new IndexOutOfBoundsException();
        }
        Array<B> dest = $this.jsSlice($this.jsSlice$default$1(), $this.jsSlice$default$2());
        dest.update(index, elem);
        return dest;
    }

    public final <A> IndexedSeqView<A> view$extension(Array<A> $this) {
        return new ArrayOps.ArrayView<A>($this);
    }

    public final <B, A> Array<A> diff$extension(Array<A> $this, Seq<B> that) {
        return ((WrappedArray)new WrappedArray<A>($this).diff(that)).array();
    }

    public final <B, A> Array<A> intersect$extension(Array<A> $this, Seq<B> that) {
        return ((WrappedArray)new WrappedArray<A>($this).intersect(that)).array();
    }

    public final <A> Iterator<Array<A>> sliding$extension(Array<A> $this, int size, int step) {
        return new WrappedArray<A>($this).sliding(size, step).map((Function1<WrappedArray, Array> & Serializable)x$6 -> x$6.array());
    }

    public final <A> int sliding$default$2$extension(Array<A> $this) {
        return 1;
    }

    public final <A> Iterator<Array<A>> combinations$extension(Array<A> $this, int n) {
        return new WrappedArray<A>($this).combinations(n).map((Function1<WrappedArray, Array> & Serializable)x$7 -> x$7.array());
    }

    public final <A> Iterator<Array<A>> permutations$extension(Array<A> $this) {
        return new WrappedArray<A>($this).permutations().map((Function1<WrappedArray, Array> & Serializable)x$8 -> x$8.array());
    }

    public final <B, A> boolean startsWith$extension(Array<A> $this, IterableOnce<B> that, int offset) {
        return new WrappedArray<A>($this).startsWith(that, offset);
    }

    public final <B, A> int startsWith$default$2$extension(Array<A> $this) {
        return 0;
    }

    public final <B, A> boolean endsWith$extension(Array<A> $this, Iterable<B> that) {
        return new WrappedArray<A>($this).endsWith(that);
    }

    public final <A> void clear$extension(Array<A> $this) {
        $this.length_$eq(0);
    }

    public final <A> Array<A> addOne$extension(Array<A> $this, A elem) {
        $this.push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{elem}));
        return $this;
    }

    public final <A> Array<A> $plus$eq$extension(Array<A> $this, A elem) {
        return this.addOne$extension($this, elem);
    }

    public final <A> Array<A> $plus$eq$extension(Array<A> $this, A elem1, A elem2, Seq<A> elems) {
        return this.$plus$plus$eq$extension(Any$.MODULE$.jsArrayOps(this.$plus$eq$extension(Any$.MODULE$.jsArrayOps(this.$plus$eq$extension($this, elem1)), elem2)), elems);
    }

    public final <A> Array<A> addAll$extension(Array<A> $this, IterableOnce<A> ys) {
        ys.iterator().foreach((Function1<Object, Array> & Serializable)x$9 -> MODULE$.addOne$extension($this, x$9));
        return $this;
    }

    public final <A> Array<A> $plus$plus$eq$extension(Array<A> $this, IterableOnce<A> ys) {
        return this.addAll$extension($this, ys);
    }

    public final <A> Array<A> subtractOne$extension(Array<A> $this, A elem) {
        int i = this.indexOf$extension($this, elem, this.indexOf$default$2$extension($this));
        BoxedUnit boxedUnit = i != -1 ? this.remove$extension($this, i) : BoxedUnit.UNIT;
        return $this;
    }

    public final <A> Array<A> $minus$eq$extension(Array<A> $this, A elem) {
        return this.subtractOne$extension($this, elem);
    }

    public final <A> Array<A> $minus$eq$extension(Array<A> $this, A elem1, A elem2, Seq<A> elems) {
        return this.$minus$minus$eq$extension(Any$.MODULE$.jsArrayOps(this.$minus$eq$extension(Any$.MODULE$.jsArrayOps(this.$minus$eq$extension($this, elem1)), elem2)), elems);
    }

    public final <A> Array<A> subtractAll$extension(Array<A> $this, IterableOnce<A> ys) {
        ys.iterator().foreach((Function1<Object, Array> & Serializable)elem -> MODULE$.subtractOne$extension($this, elem));
        return $this;
    }

    public final <A> Array<A> $minus$minus$eq$extension(Array<A> $this, IterableOnce<A> ys) {
        return this.subtractAll$extension($this, ys);
    }

    public final <A> Array<A> prepend$extension(Array<A> $this, A elem) {
        $this.unshift(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{elem}));
        return $this;
    }

    public final <A> Array<A> append$extension(Array<A> $this, A elem) {
        return this.addOne$extension($this, elem);
    }

    public final <A> Array<A> append$extension(Array<A> $this, Seq<A> elems) {
        return this.addAll$extension($this, elems);
    }

    public final <A> Array<A> appendAll$extension(Array<A> $this, IterableOnce<A> ys) {
        return this.addAll$extension($this, ys);
    }

    public final <A> Array<A> $plus$eq$colon$extension(Array<A> $this, A elem) {
        return this.prepend$extension($this, elem);
    }

    public final <A> Array<A> prependAll$extension(Array<A> $this, IterableOnce<A> elems) {
        this.insertAll$extension($this, 0, elems);
        return $this;
    }

    public final <A> Array<A> prepend$extension(Array<A> $this, Seq<A> elems) {
        return this.prependAll$extension($this, elems);
    }

    public final <A> Array<A> $plus$plus$eq$colon$extension(Array<A> $this, IterableOnce<A> elems) {
        return this.prependAll$extension($this, elems);
    }

    public final <A> void insert$extension(Array<A> $this, int idx, A elem) {
        if (idx < 0 || idx > $this.length()) {
            throw new IndexOutOfBoundsException();
        }
        $this.splice(idx, 0, ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{elem}));
    }

    public final <A> void insertAll$extension(Array<A> $this, int idx, IterableOnce<A> elems) {
        int i;
        Tuple2<Integer, Iterator<A>> tuple2;
        int len = $this.length();
        if (idx < 0 || idx > len) {
            throw new IndexOutOfBoundsException();
        }
        int n = elems.knownSize();
        switch (n) {
            case -1: {
                Array<A> elemsArray = JSConverters$JSRichIterableOnce$.MODULE$.toJSArray$extension(JSConverters$.MODULE$.JSRichIterableOnce(elems));
                tuple2 = new Tuple2<Integer, Iterator<A>>(BoxesRunTime.boxToInteger(elemsArray.length()), this.iterator$extension(Any$.MODULE$.jsArrayOps(elemsArray)));
                break;
            }
            default: {
                tuple2 = new Tuple2<Integer, Iterator<A>>(BoxesRunTime.boxToInteger(n), elems);
                break;
            }
        }
        Tuple2<Integer, Iterator<A>> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int count = tuple22._1$mcI$sp();
        IterableOnce elems0 = (IterableOnce)tuple22._2();
        Tuple2<Integer, IterableOnce> tuple23 = new Tuple2<Integer, IterableOnce>(BoxesRunTime.boxToInteger(count), elems0);
        Tuple2<Integer, IterableOnce> tuple24 = tuple23;
        int count2 = tuple24._1$mcI$sp();
        IterableOnce elems02 = tuple24._2();
        int newlen = len + count2;
        $this.length_$eq(newlen);
        int endOfInserted = idx + count2;
        for (i = newlen - 1; i >= endOfInserted; --i) {
            $this.update(i, $this.apply(i - count2));
        }
        i = idx;
        Iterator iter = elems02.iterator();
        while (iter.hasNext()) {
            $this.update(i, iter.next());
            ++i;
        }
    }

    public final <A> A remove$extension(Array<A> $this, int idx) {
        if (idx < 0 || idx >= $this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return $this.splice(idx, 1, ScalaRunTime$.MODULE$.genericWrapArray(new Object[0])).apply(0);
    }

    public final <A> void remove$extension(Array<A> $this, int idx, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (idx < 0 || count > 0 && idx > $this.length() - count) {
            throw new IndexOutOfBoundsException();
        }
        $this.splice(idx, count, ScalaRunTime$.MODULE$.genericWrapArray(new Object[0]));
    }

    public final <A> void trimStart$extension(Array<A> $this, int n) {
        $this.splice(0, this.clampIndex$extension($this, n), ScalaRunTime$.MODULE$.genericWrapArray(new Object[0]));
    }

    public final <A> void trimEnd$extension(Array<A> $this, int n) {
        $this.length_$eq($this.length() - this.clampIndex$extension($this, n));
    }

    public final <A> Array<A> patchInPlace$extension(Array<A> $this, int from, IterableOnce<A> patch, int replaced) {
        new WrappedArray<A>($this).patchInPlace(from, (IterableOnce)patch, replaced);
        return $this;
    }

    public final <A> Array<A> dropInPlace$extension(Array<A> $this, int n) {
        $this.splice(0, this.clampIndex$extension($this, n), ScalaRunTime$.MODULE$.genericWrapArray(new Object[0]));
        return $this;
    }

    public final <A> Array<A> dropRightInPlace$extension(Array<A> $this, int n) {
        this.trimEnd$extension($this, n);
        return $this;
    }

    public final <A> Array<A> takeInPlace$extension(Array<A> $this, int n) {
        $this.length_$eq(this.clampIndex$extension($this, n));
        return $this;
    }

    public final <A> Array<A> takeRightInPlace$extension(Array<A> $this, int n) {
        $this.splice(0, $this.length() - this.clampIndex$extension($this, n), ScalaRunTime$.MODULE$.genericWrapArray(new Object[0]));
        return $this;
    }

    public final <A> Array<A> sliceInPlace$extension(Array<A> $this, int start, int end) {
        return this.dropInPlace$extension(Any$.MODULE$.jsArrayOps(this.takeInPlace$extension($this, end)), start);
    }

    public final <A> int clampIndex$extension(Array<A> $this, int n) {
        return Math.min(Math.max(n, 0), $this.length());
    }

    public final <A> Array<A> dropWhileInPlace$extension(Array<A> $this, Function1<A, Object> p) {
        Array<A> array;
        int idx = this.indexWhere$extension($this, (Function1<Object, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$dropWhileInPlace$1(p, x$11)), this.indexWhere$default$2$extension($this));
        if (idx < 0) {
            this.clear$extension($this);
            array = $this;
        } else {
            array = this.dropInPlace$extension($this, idx);
        }
        return array;
    }

    public final <A> Array<A> takeWhileInPlace$extension(Array<A> $this, Function1<A, Object> p) {
        int idx = this.indexWhere$extension($this, (Function1<Object, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(ArrayOps$.$anonfun$takeWhileInPlace$1(p, x$12)), this.indexWhere$default$2$extension($this));
        return idx < 0 ? $this : this.takeInPlace$extension($this, idx);
    }

    public final <A> Array<A> padToInPlace$extension(Array<A> $this, int len, A elem) {
        while ($this.length() < len) {
            $this.push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{elem}));
        }
        return $this;
    }

    public final <A> Array<A> flatMapInPlace$extension(Array<A> $this, Function1<A, IterableOnce<A>> f) {
        boolean i = false;
        Array<A> copy = $this.jsSlice($this.jsSlice$default$1(), $this.jsSlice$default$2());
        $this.length_$eq(0);
        this.foreach$extension(Any$.MODULE$.jsArrayOps(copy), (Function1<Object, Object> & Serializable)x -> {
            ArrayOps$.$anonfun$flatMapInPlace$1(f, $this, x);
            return BoxedUnit.UNIT;
        });
        return $this;
    }

    public final <A> Array<A> filterInPlace$extension(Array<A> $this, Function1<A, Object> p) {
        block1: {
            int j = 0;
            int len = $this.length();
            for (int i = 0; i < len; ++i) {
                A x = $this.apply(i);
                if (!BoxesRunTime.unboxToBoolean(p.apply(x))) continue;
                $this.update(j, x);
                ++j;
            }
            if (j == len) break block1;
            $this.length_$eq(j);
        }
        return $this;
    }

    public final <A> int hashCode$extension(Array<A> $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <A> boolean equals$extension(Array<A> $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof ArrayOps)) return false;
        boolean bl = true;
        if (!bl) return false;
        Array array = x$1 == null ? null : ((ArrayOps)x$1).scala$scalajs$js$ArrayOps$$xs();
        Array<A> array2 = $this;
        Array array3 = array;
        if (array2 != null) {
            if (!array2.equals(array3)) return false;
            return true;
        }
        if (array3 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$takeWhile$1(Function1 p$1, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$1.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$dropWhile$1(Function1 p$2, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$2.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$span$1(Function1 p$3, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$3.apply(x));
    }

    public static final /* synthetic */ int $anonfun$partition$1(Function1 p$4, Array res1$1, Array res2$1, Object x) {
        return (BoxesRunTime.unboxToBoolean(p$4.apply(x)) ? res1$1 : res2$1).push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{x}));
    }

    public static final /* synthetic */ boolean $anonfun$filterNot$1(Function1 p$6, Object x) {
        return !BoxesRunTime.unboxToBoolean(p$6.apply(x));
    }

    public static final /* synthetic */ boolean $anonfun$indexOf$1(Object elem$1, Object x$4) {
        return BoxesRunTime.equals(elem$1, x$4);
    }

    public static final /* synthetic */ boolean $anonfun$lastIndexOf$1(Object elem$2, Object x$5) {
        return BoxesRunTime.equals(elem$2, x$5);
    }

    private static final Object d$1(Object x, BooleanRef matched$1) {
        matched$1.elem = false;
        return null;
    }

    private static final Object d$2(Object x, BooleanRef matched$2) {
        matched$2.elem = false;
        return null;
    }

    public static final /* synthetic */ int $anonfun$groupBy$1(Function1 f$5, scala.collection.mutable.Map m$1, Object x) {
        Object key = f$5.apply(x);
        return ((Array)m$1.getOrElseUpdate(key, (Function0<Array> & Serializable)() -> Array$.MODULE$.apply(Nil$.MODULE$))).push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{x}));
    }

    public static final /* synthetic */ int $anonfun$groupMap$1(Function1 key$1, scala.collection.mutable.Map m$2, Function1 f$6, Object x) {
        Object k = key$1.apply(x);
        return ((Array)m$2.getOrElseUpdate(k, (Function0<Array> & Serializable)() -> Array$.MODULE$.apply(Nil$.MODULE$))).push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{f$6.apply(x)}));
    }

    private static final int elemsToCopyToArray$1(int srcLen, int destLen, int start, int len) {
        return Math.max(Math.min(Math.min(len, srcLen), destLen - start), 0);
    }

    public static final /* synthetic */ void $anonfun$count$1(Function1 p$7, IntRef res$2, Object x) {
        block0: {
            if (!BoxesRunTime.unboxToBoolean(p$7.apply(x))) break block0;
            ++res$2.elem;
        }
    }

    public static final /* synthetic */ boolean $anonfun$dropWhileInPlace$1(Function1 p$8, Object x$11) {
        return !BoxesRunTime.unboxToBoolean(p$8.apply(x$11));
    }

    public static final /* synthetic */ boolean $anonfun$takeWhileInPlace$1(Function1 p$9, Object x$12) {
        return !BoxesRunTime.unboxToBoolean(p$9.apply(x$12));
    }

    public static final /* synthetic */ void $anonfun$flatMapInPlace$1(Function1 f$7, Array $this$3, Object x) {
        ((IterableOnce)f$7.apply(x)).iterator().foreach((Function1<Object, Object> & Serializable)y -> BoxesRunTime.boxToInteger($this$3.push(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{y}))));
    }

    private ArrayOps$() {
    }
}

